import rclpy
from rclpy.node import Node
import RPi.GPIO as GPIO
import time

from tile_detector.srv import Tap

# 定义电磁铁连接的GPIO引脚
SOLENOID_PIN = 22 # 示例引脚，请修改

class SolenoidServiceServer(Node):

    def __init__(self):
        super().__init__('solenoid_service_server')
        self.srv = self.create_service(Tap, '/trigger_tap', self.trigger_tap_callback)

        GPIO.setmode(GPIO.BCM)
        GPIO.setwarnings(False)
        GPIO.setup(SOLENOID_PIN, GPIO.OUT, initial=GPIO.LOW)

        self.get_logger().info("电磁铁敲击Service已启动，等待请求...")

    def trigger_tap_callback(self, request, response):
        self.get_logger().info('收到敲击请求...')

        try:
            GPIO.output(SOLENOID_PIN, GPIO.HIGH)
            time.sleep(0.05) # 敲击持续时间
            GPIO.output(SOLENOID_PIN, GPIO.LOW)

            response.success = True
            response.message = "敲击成功"
        except Exception as e:
            response.success = False
            response.message = f"敲击失败: {e}"

        return response

    def destroy_node(self):
        GPIO.cleanup()
        super().destroy_node()

def main(args=None):
    rclpy.init(args=args)
    node = SolenoidServiceServer()
    try:
        rclpy.spin(node)
    except KeyboardInterrupt:
        pass
    finally:
        node.destroy_node()
        rclpy.shutdown()

if __name__ == '__main__':
    main()