from launch import LaunchDescription
from launch_ros.actions import Node

def generate_launch_description():
    return LaunchDescription([
        Node(
            package='tile_detector',
            executable='sound_detector',
            name='sound_detector'
        ),
        Node(
            package='tile_detector',
            executable='solenoid_server',
            name='solenoid_server',
            # Launch-prefix can be useful for immediate output flushing
            prefix='stdbuf -o L'
        ),
        Node(
            package='tile_detector',
            executable='stepper_server',
            name='stepper_server',
            prefix='stdbuf -o L'
        ),
        Node(
            package='tile_detector',
            executable='master_controller',
            name='master_controller',
            prefix='stdbuf -o L'
        ),
    ])