from setuptools import find_packages, setup
import os
from glob import glob

package_name = 'tile_detector'

setup(
    name=package_name,
    version='0.0.0',
    packages=find_packages(exclude=['test']),
    data_files=[
        ('share/ament_index/resource_index/packages',
            ['resource/' + package_name]),
        ('share/' + package_name, ['package.xml']),
        # Include launch files
        (os.path.join('share', package_name, 'launch'), glob('launch/*.launch.py')),
        # Include srv and action files
        # These lines are crucial for colcon to find and build your custom interfaces
        ('share', glob('srv/*.srv')),
        ('share', glob('action/*.action')),
    ],
    install_requires=['setuptools'],
    zip_safe=True,
    maintainer='user',
    maintainer_email='user@todo.todo',
    description='Package for tile hollow detection robot',
    license='Apache-2.0',
    tests_require=['pytest'],
    entry_points={
        'console_scripts': [
            'sound_detector = tile_detector.sound_detector_node:main',
            'stepper_server = tile_detector.stepper_action_server:main',
            'solenoid_server = tile_detector.solenoid_service_server:main',
            'master_controller = tile_detector.master_controller_node:main',
        ],
    },
)