from setuptools import find_packages, setup
import os
from glob import glob

package_name = 'seubot_driver'

setup(
    name=package_name,
    version='0.1.0',
    # 自动查找 src 目录下的所有 python 包
    packages=find_packages(where='src'),
    # 告诉 setuptools 包的根目录是 src
    package_dir={'': 'src'},
    
    # 安装非代码文件
    data_files=[
        ('share/ament_index/resource_index/packages',
            ['resource/' + package_name]),
        ('share/' + package_name, ['package.xml']),
        # 安装 launch 文件
        (os.path.join('share', package_name, 'launch'), glob('launch/*.launch.py')),
    ],
    install_requires=['setuptools'],
    zip_safe=True,
    maintainer='Yanzhe Ji',
    maintainer_email='i@yanzhe.us',
    description='ROS 2 driver for Rosmaster series robots (SEUBot)',
    license='TODO',
    tests_require=['pytest'],
    
    # 定义可执行脚本的 "入口点"
    # 这会创建 ros2 run seubot_driver driver_node
    entry_points={
        'console_scripts': [
            'driver_node = seubot_driver.driver_node:main'
        ],
    },
)