from setuptools import setup

package_name = 'audio_tools'

setup(
    name=package_name,
    version='0.1.0',
    packages=[package_name],
    data_files=[
        ('share/ament_index/resource_index/packages', ['resource/' + package_name]),
        ('share/' + package_name, ['package.xml']),
    ],
    install_requires=['setuptools', 'numpy'],
    zip_safe=False,
    maintainer='User',
    maintainer_email='user@example.com',
    description='ROS 2 audio frequency analyzer and text-to-speech nodes',
    license='MIT',
    tests_require=['pytest'],
    entry_points={
        'console_scripts': [
            'audio_frequency_recorder = audio_tools.frequency_recorder:main',
            'text_to_speech_player = audio_tools.text_to_speech:main',
        ],
    },
)
