from dataclasses import dataclass
from typing import List, Tuple


@dataclass
class UnitSize:
    a: float = 0.5
    b: float = 0.5


class AutoService:
    def __init__(self) -> None:
        self.unit = UnitSize()
        self.plan: List[Tuple[int, float, float]] = []

    def set_unit(self, a: float, b: float) -> UnitSize:
        self.unit = UnitSize(a=a, b=b)
        return self.unit

    def plan_path(self, nx: int, ny: int, mode: str = "serpentine", start: str = "tl") -> List[Tuple[int, float, float]]:
        a, b = self.unit.a, self.unit.b
        pts: List[Tuple[int, float, float]] = []
        seq = 1

        def unit_corners(ix: int, iy: int) -> List[Tuple[int, float, float]]:
            x0 = ix * a
            y0 = iy * b
            return [
                (seq + 0, x0, y0),
                (seq + 1, x0 + a, y0),
                (seq + 2, x0 + a, y0 + b),
                (seq + 3, x0, y0 + b),
            ]

        for iy in range(ny):
            row = []
            for ix in range(nx):
                corners = unit_corners(ix, iy)
                row.append(corners)
                seq += 4
            if mode == "serpentine" and (iy % 2 == 1):
                row.reverse()
            for block in row:
                pts.extend(block)

        # TODO: apply start corner transform for tr/bl/br; keep tl as default
        self.plan = pts
        return pts


AUTO = AutoService()

