# Chiikawa Love Signal - 本地运行说明

## 目录结构
- `index.html` 前端页面（调用本地 `/api/*`）
- `app.py` Flask 后端（端口 9999）
- `assets/` 静态资源目录（图片等后期补充）
- `data/` 持久化目录（JSON 文件：`chat.json`、`diary.json`）
- `requirements.txt` 依赖

## 启动
1. 安装依赖：`pip install -r requirements.txt`
2. 配置后端密钥文件：复制 `config.example.json` 为 `config.json` 并填入实际值。
   - `BARK_API_KEY`：你的 Bark 设备 key（必填）
   - `BARK_SERVER`：可选 Bark 服务地址（默认 `https://api.yanzhe.us`）
   - `ICON_URL`：推送图标 URL（可公开）
   - `GEMINI_API_KEY`：可选，启用魔法润色
   - `PORT`：后端端口（默认 9999）
3. 运行：`python app.py`（监听 `0.0.0.0:9999`）
4. 浏览器打开 `http://localhost:9999`

## 安全与版本控制
- 仓库已添加 `.gitignore` 忽略 `config.json` 与 `data/*.json`，避免把密钥与运行数据提交到远端。
- 如需多人协作，请仅共享 `config.example.json`，不要把真实密钥上传。

## API 概览
- `POST /api/push`：代理 Bark 推送，body: `{ title?, text, sound?, level? }`
- `GET /api/chat`、`POST /api/chat`：聊天 JSON 存取
- `GET /api/diary`、`POST /api/diary`：日记 JSON 存取
- `POST /api/diary/delete`：删除日记（前端传 `{ id, password }`）。后端并非物理删除：
  - 从 `data/diary.json` 移除，并将完整日记写入 `data/delete/diary/<id>.json`
  - 若含图片，则将 `assets/uploads/<file>` 移动到 `assets/uploads/delete/<file>`
- `POST /api/upload`：上传图片（字段名 `file`），返回 `{ ok, url }`
- `GET /api/weather`：后端代理天气接口（读取 `WEATHER_API_ID/KEY`），前端用于展示与记录
- `POST /api/magic`：魔法润色代理（需 `GEMINI_API_KEY`）

注意：前端的日记列表已改为从后端加载与刷新（不再依赖 `localStorage` 作为数据源）。

## 删除密码
- 默认删除密码为 `123`，可在 `config.json` 中通过 `DELETE_PASSWORD` 修改。
