## Electromagnet Agent

This lightweight HTTP service runs in the native system environment (outside the
main panel virtualenv) and exposes GPIO control APIs that can be called from the
Flask app or any other client.

### Endpoints

- `GET /health` → `{"ok": true}` if agent is running.
- `GET /electromagnet/state` → `{"ok": true, "state": "on|off", "pin": BCM}`.
- `POST /electromagnet/activate` with JSON `{"state": "on"|"off"}` → toggles the coil.

### Run

```bash
python3 agent/electromagnet_agent.py --host 0.0.0.0 --port 5500 --pin 14
```

Environment variables:

- `AGENT_ELECTROMAGNET_PIN` overrides `--pin`.

The process must have permission to access `/dev/gpiomem` (e.g. run as root or
ensure the user is in the `gpio` group). Once the agent is running, set
`ELECTROMAGNET_AGENT_URL=http://127.0.0.1:5500` in the virtualenv before
starting the main Flask app so it proxies electromagnet calls to this agent.
