import trimesh

# 替换成你的LEGO积木STL文件的实际路径
stl_file_path = 'models/lego/1x1.STL'

# 从文件加载3D网格
mesh = trimesh.load_mesh(stl_file_path)

# --- 同样进行单位缩放 ---
# 假设STL单位是mm，我们创建一个缩放矩阵将其转换为米(m)
scale_matrix = trimesh.transformations.scale_matrix(0.001)
mesh.apply_transform(scale_matrix)

# --- 核心步骤：分别计算两个体积 ---

# 1. 计算模型的真实“几何体积”
if mesh.is_watertight:
    geometric_volume = mesh.volume
    print("--- 模型的真实几何信息 ---")
    print(f"精确几何体积: {geometric_volume:.10f} m³")
else:
    geometric_volume = mesh.volume # 即使不封闭也尝试计算
    print("--- 模型的真实几何信息 (警告: 模型不封闭) ---")
    print(f"估算几何体积: {geometric_volume:.10f} m³")

print("-" * 30)

# 2. 计算PyBullet使用的“物理体积”（即凸包的体积）
# trimesh可以非常方便地直接获取模型的凸包（它会返回一个新的、完全封闭的网格对象）
convex_hull_mesh = mesh.convex_hull

# 计算这个新凸包网格的体积
physical_volume = convex_hull_mesh.volume
print("--- PyBullet 实际使用的物理信息 ---")
print(f"凸包物理体积: {physical_volume:.10f} m³")

print("-" * 30)

# --- 对比分析 ---
volume_difference = physical_volume - geometric_volume
percentage_increase = (volume_difference / geometric_volume) * 100

print("--- 体积对比 ---")
print(f"物理体积比几何体积大: {volume_difference:.10f} m³")
print(f"这意味着PyBullet处理的体积比真实体积大了 {percentage_increase:.2f}%")
print("这个增加的体积就是被“填平”的凹槽和孔洞部分。")
