import time
# 导入 Rosmaster 类（假设Rosmaster_Lib.py已在当前路径）
from Rosmaster_Lib import Rosmaster

# 实例化 Rosmaster 类
# 请根据您的ROS开发板的串口和车体类型修改 com 和 car_type
# 例如，如果您使用的是树莓派，com 可能是 "/dev/ttyUSB0" 或 "/dev/ttyTHS1"
# 如果您在Windows上，com 可能是 "COMx"
# car_type=1 (X3), car_type=2 (X3PLUS), car_type=4 (X1), car_type=5 (R2)
try:
    bot = Rosmaster(car_type=1, com="/dev/ttyUSB0", debug=True)
    print("Rosmaster object created.")
except Exception as e:
    print(f"Error creating Rosmaster object: {e}")
    # 如果串口打开失败，尝试停止程序
    exit(1)

# 开启接收和处理数据的线程（推荐操作）
bot.create_receive_threading()
time.sleep(0.1)

try:
    print("--- 1. m2 电机向前转动 (速度: 50) ---")
    # set_motor(speed_1, speed_2, speed_3, speed_4)
    # 假设 m1=speed_1, m2=speed_2, m3=speed_3, m4=speed_4
    # 仅设置 m2 速度为 50，其他为 0
    bot.set_motor(0, 50, 0, 0)
    time.sleep(5) # 持续 1 秒

    print("--- 2. m2 电机向后转动 (速度: -50) ---")
    # 仅设置 m2 速度为 -50，其他为 0
    bot.set_motor(0, -50, 0, 0)
    time.sleep(10) # 持续 1 秒

    print("--- 3. 停止所有电机 ---")
    # 设置所有电机速度为 0
    bot.set_motor(0, 0, 0, 0)
    time.sleep(0.5)

    print("--- 测试结束 ---")

except KeyboardInterrupt:
    print("\n程序中断，停止小车。")
    bot.set_motor(0, 0, 0, 0)
except Exception as e:
    print(f"An error occurred during motor control: {e}")
    bot.set_motor(0, 0, 0, 0)

finally:
    # 确保在程序结束时关闭串口
    # bot.__del__() # 也可以手动调用析构函数，但通常程序结束时会自动调用
    pass
