#!/usr/bin/env python3
# coding: utf-8

import time
import platform
# 引入你上传的库文件
from Rosmaster_Lib import Rosmaster

def play_twinkle_star():
    # 1. 初始化机器人对象
    # 自动检测系统以选择串口 (参考库文件中的逻辑)
    device = platform.system()
    try:
        if device == 'Windows':
            # Windows下通常需要手动指定，这里尝试COM3，请根据实际情况修改
            bot = Rosmaster(com="COM3", debug=False) 
        else:
            # Linux/树莓派/Jetson Nano 通常是 /dev/ttyUSB0 或 /dev/ttyAMA0
            bot = Rosmaster(com="/dev/myserial", debug=False)
    except Exception as e:
        print("初始化失败，请检查串口连接:", e)
        return

    print("开始演奏: 小星星 (节奏版)")
    
    # 2. 定义节拍 (毫秒)
    # 因为 set_beep 的参数是毫秒
    BEAT = 400       # 一拍 (300-500ms 比较合适)
    HALF_BEAT = 800  # 两拍 (用于每句结尾的长音)
    GAP = 0.1        # 音符之间的静音间隔 (秒)，防止声音连成一片

    # 3. 定义演奏函数
    def beep_note(duration_ms):
        # 发送蜂鸣器指令
        bot.set_beep(duration_ms)
        # 等待蜂鸣器响完
        time.sleep(duration_ms / 1000.0)
        # 加上由于通讯和听感需要的额外短暂停顿
        time.sleep(GAP)

    # 4. 《小星星》乐谱 (数字代表简谱，主要看结构)
    # 结构: A - B - C - C - A - B
    
    # 第一句: 1 1 5 5 6 6 5- (一闪一闪亮晶晶)
    section_1 = [BEAT, BEAT, BEAT, BEAT, BEAT, BEAT, HALF_BEAT]
    
    # 第二句: 4 4 3 3 2 2 1- (满天都是小星星)
    section_2 = [BEAT, BEAT, BEAT, BEAT, BEAT, BEAT, HALF_BEAT]
    
    # 第三句: 5 5 4 4 3 3 2- (挂在天上放光明) - 重复两次
    section_3 = [BEAT, BEAT, BEAT, BEAT, BEAT, BEAT, HALF_BEAT]

    # 组合全曲
    full_song = []
    full_song.extend(section_1) # Twinkle twinkle little star
    full_song.extend(section_2) # How I wonder what you are
    full_song.extend(section_3) # Up above the world so high
    full_song.extend(section_3) # Like a diamond in the sky
    full_song.extend(section_1) # Twinkle twinkle little star
    full_song.extend(section_2) # How I wonder what you are

    # 5. 循环播放
    try:
        for duration in full_song:
            beep_note(duration)
            
        print("演奏结束")
        
    except KeyboardInterrupt:
        bot.set_beep(0) # 强制关闭
        print("停止演奏")
    
    del bot

if __name__ == '__main__':
    play_twinkle_star()
