"""
Schemas and lightweight validation for capture endpoints.

Note: Keeping dependencies minimal. If you need richer validation &
OpenAPI, integrate marshmallow + flask-smorest here later.
"""

from typing import Any, Dict, Optional


def parse_start_body(body: Optional[Dict[str, Any]]) -> Dict[str, Any]:
    body = body or {}
    rate = body.get("rate_hz")
    if rate is None:
        return {"rate_hz": None}
    try:
        rate_i = int(rate)
        if rate_i < 1:
            rate_i = 1
        return {"rate_hz": rate_i}
    except (TypeError, ValueError):
        # ignore invalid, caller can choose default
        return {"rate_hz": None}

