import pybullet as p
import time
import numpy as np

# 启动 PyBullet GUI
p.connect(p.GUI)

# 设置物理仿真环境的重力
p.setGravity(0, 0, -9.8)

# 加载地面和其他环境设置
p.loadURDF("models/floor.urdf", [0, 0, 0], useFixedBase=True)
#p.loadURDF("models/test/yuanzhu.urdf", [0, 0, 0.04], useFixedBase=True)
# 加载 LEGO 方块（1x1, 2x1, 2x2, 4x1）的位置设置
lego_blocks = []

# 加载 LEGO 方块的 URDF 文件并设置它们的位置
lego_blocks.append(p.loadURDF("models/lego/1x1.urdf", basePosition=[-0.025, -0.025, 0.05]))  # 1x1 方块
#lego_blocks.append(p.loadURDF("models/test/yuanzhu.urdf", basePosition=[0, 0, 0.04]))  
#lego_blocks.append(p.loadURDF("models/lego/1x1.urdf", basePosition=[0, 0, 0.031]))  # 1x1 方块
#lego_blocks.append(p.loadURDF("models/lego/2x1.urdf", basePosition=[0.00, 0, 0.0]))  # 2x1 方块
#lego_blocks.append(p.loadURDF("models/lego/2x1.urdf", basePosition=[0.00, 0, 0.036]))  # 2x1 方块
#lego_blocks.append(p.loadURDF("models/lego/2x2.urdf", basePosition=[0.04, 0, 0.01]))  # 2x2 方块
#lego_blocks.append(p.loadURDF("models/lego/4x1.urdf", basePosition=[0.06, 0, 0.01]))  # 4x1 方块

# 简单的叠放：我们将所有方块堆叠在一起
for i, lego in enumerate(lego_blocks):
    # 给每个方块设置适当的质量、惯性矩阵等（可以根据需要进一步调整）
    p.changeDynamics(lego, -1, mass=1.0, lateralFriction=0.9, restitution=0.1)  # 设置摩擦和弹性

# 运行仿真，直到用户终止
while True:
    # 模拟一步
    p.stepSimulation()

    # 控制帧率
    time.sleep(1. / 240.)


