import pybullet as p
import pybullet_data
import time

# 1. 连接到物理服务器
# p.GUI 会创建一个带图形界面的窗口
# p.DIRECT 则是不带图形界面，在后台运行
physicsClient = p.connect(p.GUI)

# 设置数据路径，以便找到pybullet自带的一些模型（比如地面）
p.setAdditionalSearchPath(pybullet_data.getDataPath())

# 2. 设置仿真环境
p.setGravity(0, 0, -9.8) # 设置重力，这是物体下落的原因

# 加载地面
p.loadURDF("plane.urdf", [0, 0, 0], useFixedBase=True)

# 加载圆柱（你的 yuanzhu.urdf）
# 注意：为了让圆柱固定不动，useFixedBase=True 是正确的
#p.loadURDF("models/test/11.urdf", [0, 0, 0.00], useFixedBase=True)
#p.loadURDF("models/test/yuanzhu.urdf", [0, 0, 0.04], useFixedBase=True)
# 加载 LEGO 方块
# **重要**：这里 useFixedBase 必须为 False (默认值)，这样它才能自由下落
# 我把它的初始高度调高了一点 (z=0.5)，这样下落过程更明显

lego_block = p.loadURDF("models/lego/model_plate_2x2.urdf", basePosition=[0.05, 0.05, 0])
lego_block = p.loadURDF("models/lego/model_plate_1x1.urdf", basePosition=[0.025, 0.025, 0.03])

#lego_block = p.loadURDF("models/test/11.urdf", basePosition=[0.025,-0.025, 0.04])

#lego_block = p.loadURDF("models/lego/1x1.urdf", basePosition=[-0.025, -0.025, 0.5])
#lego_block = p.loadURDF("models/test/44.urdf", basePosition=[0, 0, 0])
#lego_block = p.loadURDF("models/test/44.urdf", basePosition=[0, 0, 0.4])
#lego_block = p.loadURDF("models/test/11.urdf", basePosition=[0.025, 0, 0.04])
#lego_block = p.loadURDF("models/test/11.urdf", basePosition=[-0.025, 0, 0.04])
#lego_block = p.loadURDF("models/test/21.urdf", basePosition=[0, 0, 0.07])


# 3. 创建仿真循环
# 我们让仿真运行很长一段时间（比如10000步）
for i in range(1000000):
    # 核心命令：让仿真向前推进一小步
    p.stepSimulation()
    
    # 等待一小段时间，让我们可以用肉眼看到过程
    # PyBullet 默认的仿真频率是 240Hz，所以 1/240 是为了匹配实时速度
    time.sleep(1./240.)



