#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>


int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    HANDLE hDevice = NULL;

        U32 nPort = 0;
        U32 nLineEn = 0;
        U32 nLineDir = 0;
        U32 nPortData = 0;
        int x = 0;

        hDevice = ACTS2200_DEV_Create(0);
        if(hDevice == NULL)
        {
            printf("DEV_Create Error");
            getchar();

            return 0;
        }

        // 0 port 16 lines, 1-2 port 8 lines
        printf("Please Input Port[0-1]:\n");
        x = scanf("%u", &nPort);

        printf("Please Input line Enable [0x00--0xFF]:\n");
        x = scanf("%X", &nLineEn);

        printf("Please Input port data [0x00--0xFF]:\n");
        x = scanf("%X", &nPortData);

       if(ACTS2200_DO_WriteDigitalOneU32(hDevice, nPort, nLineEn, nPortData) == 0)
        {
            printf("Write DO line failed\n");
            getchar();
        }

        // readback
        if(ACTS2200_DIO_ReadBackDigitalOneU32(hDevice, nPort, &nLineDir, &nPortData) == 0)
        {
            printf("Write DIO line failed\n");
            getchar();
        }

        printf("Readback DIO Dir is 0X%04X, Value is 0X%04X,\n", nLineDir, nPortData);

        ACTS2200_DEV_Release(hDevice);

        printf("please enter any key exit\n");
        getchar();
 
        return 1;
}

