#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>


int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    HANDLE hDevice = NULL;
      HANDLE hCTRTask = NULL;
      F64 fValue = 0;
      U32 nIndex = 0;

      hDevice = ACTS2200_DEV_Create(0);
      if(hDevice == NULL)
      {
          printf("DEV_Create Error");
          getchar();

          return 0;
      }

      hCTRTask = ACTS2200_CTR_CreateTask(hDevice);
      if (hCTRTask == NULL)
      {
          printf("CTR_CreateTask Error\n");
          getchar();
          return 0;
       }

      if (!ACTS2200_CI_CreateFreqChan(hCTRTask, 0, 0.1, 10000000, ArtDAQ_Val_Hz, ArtDAQ_Val_Rising, ArtDAQ_Val_LargeRng2Ctr, 0, 4))
      {
             return 0;
      }


      if (!ACTS2200_CTR_InitTask(hCTRTask))
      {
          return 0;
      }

      if (!ACTS2200_CTR_StartTask(hCTRTask))
      {
          return 0;
      }

      printf("begin to read Counter Value:\n");

      fValue =0;
      while (!kbhit())
      {
          if (!ACTS2200_CI_ReadCounterScalarF64(hCTRTask, &fValue, NULL, 10.0))
          {
              printf("Period_CI_ReadCounterScalarU32 failed\n");
              return 0;
          }

          printf("nIndex = %u, Period = %gs\n", nIndex++, fValue);
          usleep(1000);
      }

      if (!ACTS2200_CTR_StopTask(hCTRTask))
      {
           return 0;
      }

      ACTS2200_CTR_ReleaseTask(hCTRTask);

      ACTS2200_DEV_Release(hDevice);

      printf("please enter any key to exit\n");
      getchar();

       return 1;
}

