#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>
#include <math.h>

int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

#define PI2 (6.28318531) // 2Բ

U32 AO_CreateWave(F64* fAnlgArray, ACTS2200_AO_PARAM AOParam)
{
    U32 nCyclePoints0 = 512;
    U32 nCyclePoints1 = 256;
    U32 nCyclePoints2 = 128;
    U32 nCyclePoints3 = 64;
    U32 nIndex=0;

    U32 nDataIndex = 0;
    for(nIndex=0; nIndex<AOParam.nSampsPerChan; nIndex++)
    {
        if(AOParam.CHParam[0].bChannelEn)
        {
            fAnlgArray[nDataIndex] = (F64)(sin(PI2*(nIndex%nCyclePoints0)/nCyclePoints0)*10.0);
            nDataIndex++;
        }

        if(AOParam.CHParam[1].bChannelEn)
        {
            fAnlgArray[nDataIndex] = (F64)(sin(PI2*(nIndex%nCyclePoints1)/nCyclePoints1)*5.0);
            nDataIndex++;
        }

        if(AOParam.CHParam[2].bChannelEn)
        {
            fAnlgArray[nDataIndex] = (F64)(sin(PI2*(nIndex%nCyclePoints2)/nCyclePoints2)*2.0);
            nDataIndex++;
        }

        if(AOParam.CHParam[3].bChannelEn)
        {
            fAnlgArray[nDataIndex] = (F64)(sin(PI2*(nIndex%nCyclePoints3)/nCyclePoints3)*1.0);
            nDataIndex++;
        }
    }
    return nDataIndex;
}

int main(int argc, char *argv[])
{
    ACTS2200_AO_PARAM AOParam;
     ACTS2200_AO_STATUS AOStatus;
     ACTS2200_MAIN_INFO MainInfo;
     U32 nTotalSamps = 0;
     U32 nWriteSampsPerChan = 0, nSampsPerChanWritten = 0;
     F64 fTimeout = 10.0;
     HANDLE hDevice = NULL;
	int nChannel=0;

     // һ 豸
     hDevice = ACTS2200_DEV_Create(0);
     if(hDevice == NULL)
     {
         printf("DEV_Create Error\n");
         getchar();
         return 0;
     }

     BOOL bCaled = FALSE;
     if (ACTS2200_AO_IsCaled(hDevice, &bCaled) && !bCaled)
     {
         ACTS2200_AO_SelfCal(hDevice);
     }

     memset(&AOParam, 0, sizeof(ACTS2200_AO_PARAM));
     memset(&MainInfo, 0, sizeof(MainInfo));

     ACTS2200_DEV_GetMainInfo(hDevice, &MainInfo);

     // ͨ
     for(nChannel=0; nChannel<MainInfo.AOInfo.nChannelCount; nChannel++)
     {
         AOParam.CHParam[nChannel].bChannelEn	= TRUE;
         AOParam.CHParam[nChannel].nSampRange	= ACTS2200_AO_SAMPRANGE_N10_P10V;
         AOParam.CHParam[nChannel].nReserved0	= 0;
         AOParam.CHParam[nChannel].nReserved1	= 0;
     }

     // ʱӲ
     AOParam.nSampMode				= ACTS2200_SAMPMODE_CONTINUOUS;
     AOParam.nSampsPerChan			= 1000;
     AOParam.fSampRate				= 500000.0;
     AOParam.nSampClkSrc			    = ACTS2200_VAL_LOCAL;
     AOParam.nExtSampClkEdge			= ACTS2200_VAL_FALLING;
     AOParam.bRegenModeEn			= 0;                                    // 

     // ʼ
     AOParam.StartTrig.nTrigType		= ACTS2200_VAL_NONE;
     AOParam.StartTrig.nTrigSrc	    = ACTS2200_VAL_PFI0;
     AOParam.StartTrig.nTrigDir		= ACTS2200_VAL_RISING;
     AOParam.StartTrig.bReTrig		= 0;
     AOParam.StartTrig.fTrigDigFltrMinPulseWidth		= 0.000005;             // 5us
     AOParam.StartTrig.fDelaySeconds	= 0;

     // ͣ
     AOParam.PauseTrig.nTrigType		= ACTS2200_VAL_NONE;
     AOParam.PauseTrig.nTrigSrc	    = ACTS2200_VAL_PFI0;
     AOParam.PauseTrig.nTrigDir		= ACTS2200_VAL_LOW;
     AOParam.PauseTrig.fTrigDigFltrMinPulseWidth		= 0.000005;             // 5us

     // 
     AOParam.nReserved0				= 0;
     AOParam.nReserved1				= 0;
     AOParam.nReserved2				= 0;

     // У鹤ĺϷ
     if(!ACTS2200_AO_VerifyParam(hDevice, &AOParam))
     {
         printf("дѱΪϷֵע鿴־ļACTS2200.log, ...\n");
         getchar();
     }

     // ڶ ʼAO
     if(!ACTS2200_AO_InitTask(hDevice, &AOParam))
     {
         printf("AO_InitTask Error\n");
         getchar();
     }

     // дԭ벨
     nWriteSampsPerChan = AOParam.nSampsPerChan;
     nTotalSamps = AOParam.nSampsPerChan*ACTS2200_AO_MAX_CHANNELS;
  
     F64* fAnlgArray = (F64*)malloc(sizeof(F64) * nTotalSamps);
	memset(fAnlgArray, 0, sizeof(F64) * nTotalSamps);
     AO_CreateWave(fAnlgArray, AOParam);

     U32 nFillMode = ACTS2200_FILLMODE_GroupByScanNumber;
     if(!ACTS2200_AO_WriteAnalog(hDevice, fAnlgArray, nWriteSampsPerChan, &nSampsPerChanWritten, fTimeout, nFillMode))
     {
         printf("AO_WriteAnalog Error...\n");
         getchar();
         goto Exit;
     }

     // Ĳ ʼAO
     printf("ACTS2200_AO_StartTask...\n");
     if(!ACTS2200_AO_StartTask(hDevice))
     {
         printf("AO_StartTask Error\n");
         getchar();
         goto Exit;
     }

   
     printf("start output...\n");

      while(!kbhit())
      {
	// 岽 õAO״̬
          if(!ACTS2200_AO_GetStatus(hDevice, &AOStatus))
          {
              printf("AO_GetStatus Error\n");
              getchar();
              break;
          }

          if (AOStatus.nHardUnderflowCnt > 0)
          {
              printf("nSampsPerChanAcquired=%ld bTaskDone=%d   bTriged=%d   nOverflowCount = %d\n", AOStatus.nSampsPerChanAcquired, AOStatus.bTaskDone, AOStatus.bTriged, AOStatus.nHardUnderflowCnt);
          }

          if(AOStatus.bTaskDone == TRUE)
          {
              printf("Task done, press any key to quit....\n");
              break;
          }

	//   дԭ벨
          if(!ACTS2200_AO_WriteAnalog(hDevice, fAnlgArray, nWriteSampsPerChan, &nSampsPerChanWritten, fTimeout, nFillMode))
          {
              printf("AO_WriteAnalog Error...\n");
              getchar();
              goto Exit;
          }

          usleep(20000);
      }

     // ߲ ֹͣAO
     if(!ACTS2200_AO_StopTask(hDevice))
     {
         printf("AO_StopTask Error\n");
         getchar();
     }

 Exit:
     // ڰ˲ ͷAO
     if(!ACTS2200_AO_ReleaseTask(hDevice))
     {
         printf("AO_ReleaseTask Error\n");
         getchar();
     }

     // ھŲ ͷ豸
     ACTS2200_DEV_Release(hDevice);

     free(fAnlgArray);

     getchar();

}

