#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>


int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    HANDLE hDevice = NULL;

       U32 nPort = 0;
       U8 nLineEn[32] = {0};
       U8 nLineData[32] = {0};
       int i = 0;
       int x= 0;

       hDevice = ACTS2200_DEV_Create(0);
       if(hDevice == NULL)
       {
           printf("DEV_Create Error");
           getchar();

           return 0;
       }


       printf("Please Input Port[0-1]:\n");
       x = scanf("%u", &nPort);

       // Only eg, even lines is 0, and Odd is 1, please Modify as needed.
       for(i = 0; i < 8; i++)
       {

           if(i % 2 == 1)
               nLineEn[i] = 1;
           else
               nLineEn[i] = 0;
       }


       if(ACTS2200_DI_ReadDigitalOneLines(hDevice, nPort, nLineEn, nLineData) == 0)
       {
           printf("Read DI line failed\n");
           getchar();
       }

       printf("DI value is[BIN]: ");
       for(i = 7; i >= 0; i--)
       {
           printf("%d", nLineData[i]);
       }

       printf("\n");

       ACTS2200_DEV_Release(hDevice);

       printf("please enter any key to exit\n");
       getchar();

       return 1;
}

