#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>

int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    HANDLE hDevice = NULL;
    HANDLE hCTRTask = NULL;
    U32 nHighTicks, nLowTicks;

    nHighTicks  = 100000;
    nLowTicks   = 200000;

    // 第一步 创建设备对象
    hDevice = ACTS2200_DEV_Create(0);
    if(hDevice == NULL)
    {
        printf("DEV_Create Error\n");
        getchar();
        return 0;

    }

    // 创建计数器任务
    hCTRTask = ACTS2200_CTR_CreateTask(hDevice);
    if (hCTRTask == NULL)
    {
        printf("CTR_CreateTask Error\n");
        getchar();
        return 0;
    }

    // 创建计数器通道
    if (!ACTS2200_CO_CreatePulseChanTicks(hCTRTask, 1, ACTS2200_VAL_100MHz, ArtDAQ_Val_Low, 0, nLowTicks, nHighTicks))
    {
        return 0;
    }

    // 配置任务
    if (!ACTS2200_CTR_CfgImplicitTiming(hCTRTask, ACTS2200_SAMPMODE_FINITE, 1000))
    {
        return 0;
    }

    // 初始化任务
    if (!ACTS2200_CTR_InitTask(hCTRTask))
    {
        return 0;
    }

    // 启动任务
    if (!ACTS2200_CTR_StartTask(hCTRTask))
    {
        return 0;
    }

    printf("Begin to Outputing...\n");

    ACTS2200_CTR_WaitUntilTaskDone(hCTRTask, -1);

    // 停止任务
    if (!ACTS2200_CTR_StopTask(hCTRTask))
    {
        return 0;
    }

    // 释放任务
    ACTS2200_CTR_ReleaseTask(hCTRTask);



    // 释放设备
    ACTS2200_DEV_Release(hDevice);

    printf("Output finish, please enter any key to exit\n");
    getchar();
    printf("exited\n");
    return 1;
}

