#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>

int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    HANDLE hDevice = NULL;
    HANDLE hCTRTask = NULL;
    F64 fFreq = 100000, fDutyCycle = 0.5;

    hDevice = ACTS2200_DEV_Create(0);
    if(hDevice == NULL)
    {
        printf("DEV_Create Error");
        getchar();

        return 0;
    }

    hCTRTask = ACTS2200_CTR_CreateTask(hDevice);
    if (hCTRTask == NULL)
    {
        printf("CTR_CreateTask Error\n");
        getchar();
        return 0;
     }

    if (!ACTS2200_CO_CreatePulseChanFreq(hCTRTask, 1, ArtDAQ_Val_Hz, ArtDAQ_Val_Low, 0, fFreq, fDutyCycle))
    {
        return 0;
    }

    if (!ACTS2200_CTR_CfgImplicitTiming(hCTRTask, ACTS2200_SAMPMODE_CONTINUOUS, 1000))
    {
           return 0;
    }

    if (!ACTS2200_CTR_InitTask(hCTRTask))
    {
        return 0;
    }

    if (!ACTS2200_CTR_StartTask(hCTRTask))
    {
        return 0;
    }

    printf("begin to read Counter Value:\n");

    while (!kbhit())
    {
        usleep(10000);
        if (fFreq < 10000000)
        {
            fFreq += 1000;

            printf("Generation Frequency = %gHz, DutyCycle = %.2f\%%\n", fFreq, fDutyCycle * 100);
            if (!ACTS2200_CO_WriteFreqScalar(hCTRTask, fFreq, fDutyCycle, 10.0))
            {
                printf("Write timeout occur.\n");
                return 0;
           }
        }
    }

    if (!ACTS2200_CTR_StopTask(hCTRTask))
    {
         return 0;
    }

    ACTS2200_CTR_ReleaseTask(hCTRTask);

    ACTS2200_DEV_Release(hDevice);

    printf("please enter any key to exit\n");
    getchar();
    getchar();
    printf("exited\n");
    return 1;
}

