#include "../../../lib/ACTS2200.h"
#include "stdio.h"
#include "string.h"
#include <termios.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <time.h>
#include <stdbool.h>


int kbhit()
{
    struct timeval tv;
    struct termios old_termios, new_termios;
    int error;
    int count = 0;
    tcgetattr(0, &old_termios);
    new_termios = old_termios;
    new_termios.c_lflag &= ~ICANON;
    new_termios.c_lflag &= ~ECHO;
    new_termios.c_cc[VMIN] = 1;
    new_termios.c_cc[VTIME] = 0;
    error = tcsetattr(0, TCSANOW, &new_termios);
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    select(1, NULL, NULL, NULL, &tv);
    error += ioctl(0, FIONREAD, &count);
    error += tcsetattr(0, TCSANOW, &old_termios);
    return error == 0 ? count : -1;
}

int main(int argc, char *argv[])
{
    ACTS2200_AI_PARAM AIParam;
       ACTS2200_AI_STATUS AIStatus;

       U32 nChannel = 0;
       U32 nReadSampsPerChan = 10, nSampsPerChanRead = 0;
       F64 fAnlgArray[16 * 10];
       F64 fTimeout = 10.0; // 10秒钟超时
       U32 nFillMode = ACTS2200_FILLMODE_GroupByScanNumber;
       HANDLE hDevice = NULL;
       U32 nSerialCode = 0;
	int i = 0;


       // 第一步 创建设备对象
       hDevice = ACTS2200_DEV_Create(nSerialCode);
       if(hDevice == NULL)
       {
           printf("DEV_Create Error\n");
           getchar();
           return 0;
       }

       BOOL bCaled = FALSE;
       if (ACTS2200_AI_IsCaled(hDevice, &bCaled) && !bCaled)
       {
           printf("ACTS2200_AI_SelfCal\n");
           ACTS2200_AI_SelfCal(hDevice);
       }

       memset(&AIParam, 0, sizeof(ACTS2200_AI_PARAM));

       // 通道参数
       AIParam.nSampChanCount      = 16;
       AIParam.nSampSignal         = ACTS2200_AI_SAMPSIGNAL_4D096V;
       AIParam.nReserved0          = 0;
       AIParam.nReserved1          = 0;
       for(nChannel=0; nChannel <  AIParam.nSampChanCount; nChannel++)
       {
           AIParam.CHParam[nChannel].nChannel      = nChannel;
           AIParam.CHParam[nChannel].nSampRange    = 0;
           AIParam.CHParam[nChannel].nRefGround    = ACTS2200_AI_REFGND_RSE;

           AIParam.CHParam[nChannel].nReserved0    = 0;
           AIParam.CHParam[nChannel].nReserved1    = 0;
           AIParam.CHParam[nChannel].nReserved2    = 0;
       }

       // 时钟参数
       AIParam.nSampMode                                   = ACTS2200_SAMPMODE_ONE_DEMAND;
       AIParam.nSampsPerChan                               = nReadSampsPerChan;
       AIParam.fSampRate                                   = 5000;
       AIParam.nExtSampClkEdge                             = 1;
       AIParam.nReserved3                                  = 0;

       // 开始触发参数
       AIParam.StartTrig.nTrigType                         = ACTS2200_VAL_NONE;
       AIParam.StartTrig.nTrigSrc                          = 0;
       AIParam.StartTrig.nTrigDir                          = 0;
       AIParam.StartTrig.bReTrig                           = 0;
       AIParam.StartTrig.fTrigLvlTop                       = 0.5; // 0.5V
       AIParam.StartTrig.fTrigLvlBtm                       = -0.5; // -0.5V
       AIParam.StartTrig.fTrigDigFltrMinPulseWidth         = 5;
       AIParam.StartTrig.fDelaySeconds                       = 0;

       // 暂停触发参数
       AIParam.PauseTrig.nTrigType                         = ACTS2200_VAL_NONE;
       AIParam.PauseTrig.nTrigSrc                          = 0;
       AIParam.PauseTrig.nTrigDir                          = 0;
       AIParam.PauseTrig.fTrigLvlTop                       = 0.5; // 0.5V
       AIParam.PauseTrig.fTrigLvlBtm                       = -0.5; // -0.5V
       AIParam.PauseTrig.fTrigDigFltrMinPulseWidth         = 0;

       // 校验参数合法性
       printf("ACTS2200_AI_VerifyParam\n");
       if(!ACTS2200_AI_VerifyParam(hDevice, &AIParam))
       {
           printf("参数有错，已被调整为合法值，按任意键继续...\n");
           getchar();
       }

       // 第二步 初始化AI采集任务
       printf("ACTS2200_AI_InitTask\n");
       if(!ACTS2200_AI_InitTask(hDevice, &AIParam))
       {
           printf("AI_InitTask Error\n");
           getchar();
           goto Exit;
       }

       // 第三步 开始AI采集任务
       printf("ACTS2200_AI_StartTask\n");
       if(!ACTS2200_AI_StartTask(hDevice))
       {
           printf("AI_StartTask Error\n");
           getchar();
           goto Exit;
       }

       // 第四步 发送软件触发事件(硬件外触发时不需要)
       printf("ACTS2200_AI_SendSoftTrig\n");
       if(!ACTS2200_AI_SendSoftTrig(hDevice))
       {
           printf("AI_SendSoftTrig Error\n");
           getchar();
           goto Exit;
       }

       printf("Continuous Read ...\n");
       while (!kbhit())
       {
           // 第五步 读取AI数据
           if(!ACTS2200_AI_ReadAnalog(hDevice, fAnlgArray, nReadSampsPerChan, &nSampsPerChanRead, fTimeout, nFillMode))
           {
               printf("Timeout nSampsPerChanRead=%d\n", nSampsPerChanRead);
               getchar();
           }

           for(i = 0; i < AIParam.nSampChanCount ; i++)
           {
               if(i % 4 == 0)
                   printf("\n");
               printf("AI[%d]: %0.4f  ", i, fAnlgArray[i]);

           }

           printf("\n");
       }

   Exit:

       // 第六步 停止AI采集任务
       if(!ACTS2200_AI_StopTask(hDevice))
       {
           printf("AI_StopTask Error\n");
           getchar();
       }

       // 第七步 释放AI采集任务
       if(!ACTS2200_AI_ReleaseTask(hDevice))
       {
           printf("AI_ReleaseTask Error\n");
           getchar();
       }

       // 第八步 释放设备对象
       ACTS2200_DEV_Release(hDevice);

       printf("\nPress any key to quit...\n");
       getchar();

}

